<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Spatie\Activitylog\Models\Activity;

class CustomActivity extends Activity
{
    /**
     * Override the getDescriptionForEvent method to customize the description.
     *
     * @param string $eventName
     * @return string
     */
    public function getDescriptionForEvent(string $eventName): string
    {
        $description = sprintf(
            '%s Slide ID: %d, Group Name: %s, Heading: %s by %s',
            ucfirst($eventName),
            $this->subject->id,
            $this->subject->group_name,
            $this->subject->heading,
            $this->causer ? $this->causer->name : 'Unknown User'
        );

        return $description;
    }
}

