<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Spatie\Activitylog\LogOptions;
use Spatie\Activitylog\Models\Activity;
use Spatie\Activitylog\Traits\LogsActivity;

class Slide extends Model
{
    use LogsActivity;
use SoftDeletes;
    protected static $logName = 'slide';
    protected static $logAttributes = ['group_name', 'heading', 'list_items'];

  protected $fillable = [
    'group_name',
    'heading',
    'created_by',
    'updated_by',
];
 protected $dates = ['deleted_at']; 
    /**
     * Get the log options for the model.
     *
     * @return LogOptions
     */
    public function getActivitylogOptions(): LogOptions
    {
        return LogOptions::defaults()
            ->logAll()
            ->logOnly(['group_name', 'heading', 'list_items'])
            ->useLogName('slide');
    }

    /**
     * Customize the log message and add additional details.
     *
     * @param Activity $activity
     * @param string $eventName
     * @return void
     */
    public static function tapActivity(Activity $activity, string $eventName)
    {
        $slide = $activity->subject;

        // Customize the log message
        $activity->description = sprintf(
            '%s Slide ID: %d, Group Name: %s',
            ucfirst($eventName),
            $slide->id,
            $slide->group_name,
            $slide->heading,
            auth()->user() ? auth()->user()->name : 'Unknown User'
        );
    }

    /**
     * Define the relationship with list items.
     */
    public function listItems()
    {
        return $this->hasMany(ListItem::class);
    }

    /**
     * Define the relationship with the user who created the slide.
     */
    public function creator()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    /**
     * Define the relationship with the user who last updated the slide.
     */
    public function updater()
    {
        return $this->belongsTo(User::class, 'updated_by');
    }
}



