<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('footer_backlinks', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->string('website_url');
            $table->timestamps();
        });

        Schema::create('footer_anchors', function (Blueprint $table) {
            $table->id();
            $table->foreignId('footer_backlink_id')->constrained()->onDelete('cascade');
            $table->string('anchor_text');
            $table->string('domain');
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('footer_anchors');
        Schema::dropIfExists('footer_backlinks');
    }
};
