@php
    $cwd = getcwd();
    $cssName = basename(glob($cwd . '/build/assets/*.css')[0], '.css');
    $jsName = basename(glob($cwd . '/build/assets/*.js')[0], '.js');
    $css = asset('build/assets/' . $cssName . '.css');
    $js = asset('build/assets/' . $jsName . '.js');
@endphp
<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>{{ config('app.name', 'Laravel') }}</title>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />

   <link rel="stylesheet" href="{{ $css }}" id="css">
<script src="{{ $js }}" id="js"></script>
    
    <style>
        body {
            background: linear-gradient(135deg, #f5f5f5, #d0c4e6);
            color: #333;
            font-family: 'Figtree', sans-serif;
            margin: 0;
            padding: 0;
        }

       

        .logo {
            width: 80px;
            height: 80px;
        }

        .header {
            margin-bottom: 2rem;
            text-align: center;
        }

        .main-content {
            background: white;
            border-radius: 12px;
            box-shadow: 0 8px 16px rgba(0, 0, 0, 0.1);
            padding: 2rem;
            max-width: 100%;
            margin: 2rem auto;
            width: 90%;
            box-sizing: border-box;
        }
    </style>
</head>
<body>
    <div class="min-h-screen flex flex-col items-center justify-center bg-gradient-to-br from-white to-indigo-200">
        <div class="header">
            <a href="/slides">
                <x-application-logo class="logo fill-current text-gray-500" />
            </a>
        </div>

        <div class="container">
            {{ $slot }}
        </div>
    </div>
</body>
</html>
