@extends('layouts.app')

@section('title', 'Slide History')

@section('content')
<div class="container mx-auto p-6">
    <h1 class="text-3xl font-bold text-gray-900 mb-6">Slide History</h1>

    <div class="bg-white shadow-lg p-6 rounded-lg">
        <h2 class="text-2xl font-semibold text-gray-800 mb-4">Recent Activity</h2>
        <ul class="list-disc list-inside space-y-2">
            @forelse($activities as $activity)
                <li class="flex items-start space-x-2">
                    <strong class="text-gray-900">
                        {{ $activity->causer ? $activity->causer->name : 'Deleted User' }}
                    </strong>
                    <span class="text-gray-700">{{ $activity->description }}</span>
                    <span class="text-gray-600">at <em>{{ $activity->created_at->format('Y-m-d H:i') }}</em></span>
                </li>
            @empty
                <li class="text-gray-600">No recent activity.</li>
            @endforelse
        </ul>
    </div>
</div>
@endsection
