@extends('layouts.app')

@section('title', 'Slides')

@section('content')
<div class="container mx-auto p-6">
    <h1 class="text-3xl font-extrabold text-gray-800 mb-6">Slides</h1>

    <div class="flex space-x-4 mb-6">
        <a href="{{ route('slides.create') }}" class="bg-purple-600 hover:bg-purple-700 text-white px-5 py-2 rounded shadow flex items-center">
            <i class="fas fa-plus mr-2"></i> Create New Slide
        </a>
        @if($currentUserRole == 2)
            <a href="{{ route('backup.download') }}" class="bg-purple-600 hover:bg-purple-700 text-white px-5 py-2 rounded shadow flex items-center">
                <i class="fas fa-download mr-2"></i> Download Database Backup
            </a>
            <a href="{{ route('slides.history') }}" class="bg-purple-600 hover:bg-purple-700 text-white px-5 py-2 rounded shadow flex items-center">
                <i class="fas fa-history mr-2"></i> View History
            </a>
            <a href="{{ route('slides.trash') }}" class="bg-purple-600 hover:bg-purple-700 text-white px-5 py-2 rounded shadow flex items-center">
                <i class="fa fa-trash mr-2"></i> Trash
            </a>
        @endif
    </div>

    @if(session('success'))
        <div class="bg-green-500 text-white p-3 rounded shadow mb-6 flex items-center">
            <i class="fas fa-check-circle mr-2"></i> {{ session('success') }}
        </div>
    @endif

    @if(!$slides->isEmpty())
    @foreach($slides as $slide)
        <div class="bg-white shadow-lg p-6 mb-6 rounded-lg flex justify-between items-center">
            <div>
                <h2 class="text-2xl font-bold text-purple-700">{{ $slide->group_name }}</h2>
                <p class="text-gray-600">{{ $slide->heading }}</p>
            </div>
            <div class="flex space-x-4">
                <a href="{{ route('slides.edit', $slide) }}" class="bg-yellow-500 hover:bg-yellow-600 text-white px-5 py-2 rounded shadow flex items-center">
                    <i class="fas fa-edit mr-2"></i> Edit
                </a>
                <a href="{{ route('slides.show', $slide) }}" class="bg-blue-500 hover:bg-blue-600 text-white px-5 py-2 rounded shadow flex items-center">
                    <i class="fas fa-eye mr-2"></i> View
                </a>
                <form action="{{ route('slides.destroy', $slide) }}" method="POST">
                    @csrf
                    @method('DELETE')
                    <button class="bg-red-500 hover:bg-red-600 text-white px-5 py-2 rounded shadow flex items-center">
                        <i class="fas fa-trash-alt mr-2"></i> Delete
                    </button>
                </form>
            </div>
        </div>
    @endforeach

    <!-- Pagination Links -->
    <div class="mt-6">
        {{ $slides->links() }}
    </div>
@endif
</div>
@endsection
