@extends('layouts.app')

@section('title', 'Trash')

@section('content')
<div class="container mx-auto p-6">
    <h1 class="text-3xl font-extrabold text-gray-800 mb-6">Trash</h1>

    <div class="flex space-x-4 mb-6">
        <a href="{{ route('slides.index') }}" class="bg-purple-600 hover:bg-purple-700 text-white px-5 py-2 rounded shadow flex items-center">
            <i class="fas fa-arrow-left mr-2"></i> Back to Slides
        </a>
    </div>

    @if(session('success'))
        <div class="bg-green-500 text-white p-3 rounded shadow mb-6 flex items-center">
            <i class="fas fa-check-circle mr-2"></i> {{ session('success') }}
        </div>
    @endif

    @if($slides->isEmpty())
        <div class="bg-yellow-100 text-yellow-800 p-3 rounded shadow mb-6">
            <i class="fas fa-info-circle mr-2"></i> No slides in trash.
        </div>
    @else
        @foreach($slides as $slide)
            <div class="bg-white shadow-lg p-6 mb-6 rounded-lg flex justify-between items-center">
                <div>
                    <h2 class="text-2xl font-bold text-purple-700">{{ $slide->group_name }}</h2>
                    <p class="text-gray-600">{{ $slide->heading }}</p>
                </div>
                <div class="flex space-x-4">
                    <form action="{{ route('slides.restore', $slide->id) }}" method="POST" x-data="{ open: false }">
                        @csrf
                        <button type="button" @click="open = true" class="bg-blue-500 hover:bg-blue-600 text-white px-5 py-2 rounded shadow flex items-center">
                            <i class="fas fa-undo mr-2"></i> Restore
                        </button>
                        <div x-show="open" @click.away="open = false" class="fixed inset-0 flex items-center justify-center z-50">
                            <div class="absolute inset-0 bg-black bg-opacity-60 z-40"></div>
                            <div class="bg-white p-6 rounded-lg shadow-lg relative z-50 max-w-sm w-full">
                                <h3 class="text-lg font-semibold mb-4">Are you sure?</h3>
                                <p class="mb-6">Do you really want to restore this slide?</p>
                                <div class="flex justify-end space-x-4">
                                    <button @click.prevent="open = false" class="bg-gray-500 hover:bg-gray-600 text-white px-4 py-2 rounded">Cancel</button>
                                    <button type="submit" class="bg-blue-500 hover:bg-blue-600 text-white px-4 py-2 rounded">Confirm</button>
                                </div>
                            </div>
                        </div>
                    </form>
                    

                </div>
            </div>
        @endforeach
        {{ $slides->links() }}
    @endif
</div>
@endsection
