<?php echo csrf_field(); ?>
<div class="form-group">
    <label for="title" class="text-sm font-semibold text-gray-700">Title</label>
    <input type="text" name="title" id="title" class="form-control w-full px-4 py-2 border border-gray-300 rounded-md focus:ring-2 focus:ring-blue-500" value="<?php echo e(old('title', $hiddenBacklink->title ?? '')); ?>" required>
</div>

<div class="form-group mt-4">
    <label for="website_url" class="text-sm font-semibold text-gray-700">Website URL</label>
    <input type="url" name="website_url" id="website_url" class="form-control w-full px-4 py-2 border border-gray-300 rounded-md focus:ring-2 focus:ring-blue-500" value="<?php echo e(old('website_url', $hiddenBacklink->website_url ?? '')); ?>" required>
</div>

<div class="border p-2">  
    <h4 class="mt-6 text-lg font-bold text-gray-800">Anchors</h4>
    <div id="anchors" class="space-y-4 mt-4">
        <?php $__currentLoopData = old('anchors', $hiddenBacklink->anchors ?? [['anchor_text' => '', 'domain' => '']]); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $anchor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="anchor-group flex items-center space-x-4">
            <input type="text" name="anchors[<?php echo e($index); ?>][anchor_text]" class="form-control w-full px-4 py-2 border border-gray-300 rounded-md focus:ring-2 focus:ring-blue-500" placeholder="Anchor Text" value="<?php echo e(old('anchors.' . $index . '.anchor_text', $anchor['anchor_text'] ?? '')); ?>" required>
            <input type="hidden" name="anchors[<?php echo e($index); ?>][domain]" class="domain-input" value="<?php echo e(old('anchors.' . $index . '.domain', $anchor['domain'] ?? '')); ?>">
            <button type="button" class="btn domain-btn bg-blue-500 text-white px-3 py-1 rounded-md hover:bg-blue-600">Domain</button>
            <button type="button" class="btn list-domain-btn bg-green-500 text-white px-3 py-1 text-nowrap rounded-md hover:bg-green-600">List Domain</button>
            <button type="button" class="btn delete-anchor bg-red-500 text-white px-3 py-1 rounded-md hover:bg-red-600">Delete</button>
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>

    <button type="button" id="add-anchor" class="btn bg-gray-500 text-white px-6 py-2 rounded-md mt-4 hover:bg-gray-600">Add Anchor</button>
</div>

<!-- Domain Popup -->
<div id="domain-popup" class="popup hidden fixed inset-0 flex items-center justify-center bg-gray-900 bg-opacity-50">
    <div class="bg-white p-6 rounded-lg shadow-lg w-96">
        <textarea rows="8" id="domain-input" class="form-control w-full px-4 py-2 border border-gray-300 rounded-md focus:ring-2 focus:ring-blue-500" placeholder="Enter domain"></textarea>
        <button id="save-domain" class="btn bg-blue-500 text-white px-6 py-2 rounded-md mt-4 hover:bg-blue-600">Save</button>
        <button id="close-popup" class="btn bg-red-500 text-white px-6 py-2 rounded-md mt-4 hover:bg-red-600">Close</button>
    </div>
</div>

<!-- List Domain Popup -->
<div id="list-domain-popup" class="popup hidden fixed inset-0 flex items-center justify-center bg-gray-900 bg-opacity-50">
    <div class="bg-white p-6 rounded-lg shadow-lg w-96">
        <ul id="domain-list" class="text-gray-800 " style="white-space: pre-line;"></ul> <!-- Ensure each domain appears on its own line -->
        <button id="close-list-popup" class="btn bg-red-500 text-white px-6 py-2 rounded-md mt-4 hover:bg-red-600">Close</button>
    </div>
</div>

<script>
   document.addEventListener('click', function(event) {
    // Delete anchor
    if (event.target.classList.contains('delete-anchor')) {
        event.target.closest('.anchor-group').remove();
    }

    // Show Domain Popup
    if (event.target.classList.contains('domain-btn')) {
        event.preventDefault(); // Prevent form submission
        let parentGroup = event.target.closest('.anchor-group');
        let domainInputField = parentGroup.querySelector('.domain-input'); 
        let domainPopup = document.getElementById('domain-popup');
        let domainInput = document.getElementById('domain-input');

        domainInput.value = domainInputField.value || ''; 
        domainPopup.classList.remove('hidden');

        document.getElementById('save-domain').onclick = function(event) {
            event.preventDefault(); 
            domainInputField.value = domainInput.value;
            domainPopup.classList.add('hidden');
        };
    }

    // Show List Domain Popup for the specific anchor
    if (event.target.classList.contains('list-domain-btn')) {
        event.preventDefault(); // Prevent form submission
        let parentGroup = event.target.closest('.anchor-group');
        let domainInputField = parentGroup.querySelector('.domain-input');
        let listContainer = document.getElementById('domain-list');
        
        // Clear existing list every time the popup is opened
        listContainer.innerHTML = '';

        // Get the domains from the textarea (splitting by newlines)
        let domainValues = domainInputField.value.trim();
        
        if (domainValues) {
            // Split by newlines
            let domains = domainValues.split(/\n+/);  // Split by newlines

            domains.forEach(function(domainValue, index) {
                domainValue = domainValue.trim();
                if (domainValue) {
                    // Create a new list item for each domain
                    let li = document.createElement('li');
                    
                    // Display number and domain
                    let domainCount = listContainer.getElementsByTagName('li').length + 1;
                    li.textContent = `${domainCount}. `;

                    // Create an anchor tag for the domain
                    let anchor = document.createElement('a');
                    anchor.href = `https://${domainValue}`;  // Make it a clickable link
                    anchor.textContent = domainValue;
                    
                    // Append the anchor to the list item
                    li.appendChild(anchor);

                    // Append the new domain to the list
                    listContainer.appendChild(li);
                }
            });

            // Clear the input field after adding the domains to the list
            domainInputField.value = '';
        }

        // Show the list domain popup
        document.getElementById('list-domain-popup').classList.remove('hidden');
    }
});

document.getElementById('close-popup').addEventListener('click', function (event) {
    event.preventDefault(); // Prevent form submission
    document.getElementById('domain-popup').classList.add('hidden');
});

document.getElementById('close-list-popup').addEventListener('click', function (event) {
    event.preventDefault(); // Prevent form submission
    let parentGroup = document.querySelector('.anchor-group'); // Get the current anchor group
    let domainInputField = parentGroup.querySelector('.domain-input'); 

    // Update the domain input field with the list of domains (from the list popup)
    let domainList = document.getElementById('domain-list');
    let domains = [];

    // Loop through the list items and get the domains
    Array.from(domainList.getElementsByTagName('li')).forEach((li) => {
        let domain = li.textContent.trim().replace(/^(\d+\.\s+)/, ''); // Remove the numbering part
        domains.push(domain);
    });

    // Update the hidden domain input field with the domains
    domainInputField.value = domains.join('\n'); // Join the domains back with newlines

    // Close the list domain popup
    document.getElementById('list-domain-popup').classList.add('hidden');
});

</script>
<?php /**PATH C:\Users\USER\Downloads\PBN_Panel\resources\views/hidden_backlinks/form.blade.php ENDPATH**/ ?>