

<?php $__env->startSection('title', 'Slides'); ?>

<?php $__env->startSection('content'); ?>
<div class="container mx-auto p-6">
    <h1 class="text-3xl font-extrabold text-gray-800 mb-6">Slides</h1>

    <div class="flex space-x-4 mb-6">
        <a href="<?php echo e(route('slides.create')); ?>" class="bg-purple-600 hover:bg-purple-700 text-white px-5 py-2 rounded shadow flex items-center">
            <i class="fas fa-plus mr-2"></i> Create New Slide
        </a>
        <?php if($currentUserRole == 2): ?>
            <a href="<?php echo e(route('backup.download')); ?>" class="bg-purple-600 hover:bg-purple-700 text-white px-5 py-2 rounded shadow flex items-center">
                <i class="fas fa-download mr-2"></i> Download Database Backup
            </a>
            <a href="<?php echo e(route('slides.history')); ?>" class="bg-purple-600 hover:bg-purple-700 text-white px-5 py-2 rounded shadow flex items-center">
                <i class="fas fa-history mr-2"></i> View History
            </a>
            <a href="<?php echo e(route('slides.trash')); ?>" class="bg-purple-600 hover:bg-purple-700 text-white px-5 py-2 rounded shadow flex items-center">
                <i class="fa fa-trash mr-2"></i> Trash
            </a>
        <?php endif; ?>
    </div>

    <?php if(session('success')): ?>
        <div class="bg-green-500 text-white p-3 rounded shadow mb-6 flex items-center">
            <i class="fas fa-check-circle mr-2"></i> <?php echo e(session('success')); ?>

        </div>
    <?php endif; ?>

    <?php if(!$slides->isEmpty()): ?>
    <?php $__currentLoopData = $slides; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $slide): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="bg-white shadow-lg p-6 mb-6 rounded-lg flex justify-between items-center">
            <div>
                <h2 class="text-2xl font-bold text-purple-700"><?php echo e($slide->group_name); ?></h2>
                <p class="text-gray-600"><?php echo e($slide->heading); ?></p>
            </div>
            <div class="flex space-x-4">
                <a href="<?php echo e(route('slides.edit', $slide)); ?>" class="bg-yellow-500 hover:bg-yellow-600 text-white px-5 py-2 rounded shadow flex items-center">
                    <i class="fas fa-edit mr-2"></i> Edit
                </a>
                <a href="<?php echo e(route('slides.show', $slide)); ?>" class="bg-blue-500 hover:bg-blue-600 text-white px-5 py-2 rounded shadow flex items-center">
                    <i class="fas fa-eye mr-2"></i> View
                </a>
                <form action="<?php echo e(route('slides.destroy', $slide)); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('DELETE'); ?>
                    <button class="bg-red-500 hover:bg-red-600 text-white px-5 py-2 rounded shadow flex items-center">
                        <i class="fas fa-trash-alt mr-2"></i> Delete
                    </button>
                </form>
            </div>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

    <!-- Pagination Links -->
    <div class="mt-6">
        <?php echo e($slides->links()); ?>

    </div>
<?php endif; ?>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/pbnsliderpanel/public_html/resources/views/slides/index.blade.php ENDPATH**/ ?>