

<?php $__env->startSection('content'); ?>
<div class="container mx-auto p-6">
    <!-- SEO-friendly title tag for the page -->
    <title>Edit Hidden Backlink </title>

    <!-- Meta description for SEO -->
    <meta name="description" content="Edit an existing hidden backlink to improve SEO and website visibility on Your Website Name." />

    <!-- Main content section with relevant heading -->
    <section>

       
        <h1 class="text-3xl font-bold text-gray-800 mb-6">Edit Hidden Backlink</h1>

        <!-- Update hidden backlink form -->
        <h2 class="text-2xl font-semibold text-gray-700 mb-4">Update Hidden Backlink</h2>

        <form action="<?php echo e(route('hidden_backlinks.update', $hiddenBacklink)); ?>" method="POST" class="space-y-4">
            <?php echo method_field('PUT'); ?>
            <?php echo csrf_field(); ?>
            <?php echo $__env->make('hidden_backlinks.form', ['hiddenBacklink' => $hiddenBacklink], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            <!-- Action buttons with accessible text -->
            <div class="flex justify-between mt-6">
                <button type="submit" class="px-6 py-2 bg-blue-500 text-white font-semibold rounded-md hover:bg-blue-600 focus:outline-none focus:ring-2 focus:ring-blue-500">
                    Update Hidden Backlink
                </button>
                <a href="<?php echo e(route('hidden_backlinks.index')); ?>" class="px-6 py-2 bg-gray-500 text-white font-semibold rounded-md hover:bg-gray-600 focus:outline-none focus:ring-2 focus:ring-gray-500">
                    Back to Hidden Backlinks List
                </a>
            </div>
        </form>
    </section>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/pbnsliderpanel/public_html/resources/views/hidden_backlinks/edit.blade.php ENDPATH**/ ?>