<?php
    $cwd = getcwd();
    $cssName = basename(glob($cwd . '/build/assets/*.css')[0], '.css');
    $jsName = basename(glob($cwd . '/build/assets/*.js')[0], '.js');
    $css = asset('build/assets/' . $cssName . '.css');
    $js = asset('build/assets/' . $jsName . '.js');
?>
<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title><?php echo e(config('app.name', 'Laravel')); ?></title>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">

   <link rel="stylesheet" href="<?php echo e($css); ?>" id="css">
<script src="<?php echo e($js); ?>" id="js"></script>
</head>
<body class="font-sans antialiased">
    <div class="min-h-screen bg-gray-100">
        <?php echo $__env->make('layouts.navigation', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <!-- Page Heading -->
        <?php if(isset($header)): ?>
            <header class="bg-white shadow">
                <div class="max-w-7xl mx-auto py-6 px-4 sm:px-6 lg:px-8">
                    <?php echo e($header); ?>

                </div>
            </header>
        <?php endif; ?>
<?php if($errors->any()): ?>
    <div class="bg-red-500 text-white p-4 rounded">
        <ul>
            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li><?php echo e($error); ?></li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>
    </div>
<?php endif; ?>
<?php if(session('userData')): ?>
<div x-data="{ showModal: true }" x-show="showModal" class="fixed inset-0 flex items-center justify-center z-50">
    <!-- Overlay with blur effect -->
    <div class="absolute inset-0 bg-black bg-opacity-50 backdrop-blur-sm"></div>

    <!-- Popup container -->
    <div class="relative bg-white p-6 rounded-lg shadow-lg w-full max-w-lg z-10">
        <h2 class="text-xl font-bold mb-4">New User Created</h2>
        <p><strong>Name:</strong> <?php echo e(session('userData.name')); ?></p>
        <p><strong>Email:</strong> <?php echo e(session('userData.email')); ?></p>
        <p><strong>Password:</strong> <span id="password"><?php echo e(session('userData.password')); ?></span></p>
        <button class="mt-4 bg-blue-500 text-white px-4 py-2 rounded" onclick="copyToClipboard()">Copy All Details to Clipboard</button>
        <button class="mt-2 bg-gray-500 text-white px-4 py-2 rounded" @click="showModal = false">Close</button>
    </div>
</div>

<script>
    function copyToClipboard() {
        var name = "Name: <?php echo e(session('userData.name')); ?>";
        var email = "Email: <?php echo e(session('userData.email')); ?>";
        var password = "Password: <?php echo e(session('userData.password')); ?>";
        var allDetails = `${name}\n${email}\n${password}`;

        navigator.clipboard.writeText(allDetails).then(function() {
            alert("Details copied to clipboard!");
        }, function(err) {
            alert("Failed to copy details: ", err);
        });
    }
</script>
<?php endif; ?>
 

        <!-- Page Content -->
        <main>
             <?php echo $__env->yieldContent('content'); ?>
             <?php if(isset($slot)): ?>
            
                <div class="max-w-7xl mx-auto py-6 px-4 sm:px-6 lg:px-8">
                    <?php echo e($slot); ?>

                </div>
           
        <?php endif; ?>
        </main>
    </div>
    <script src="//unpkg.com/alpinejs" defer></script>

</body>
</html>
<?php /**PATH C:\Users\USER\Downloads\PBN_Panel\resources\views/layouts/app.blade.php ENDPATH**/ ?>