

<?php $__env->startSection('content'); ?>
<div class="container mx-auto p-6">
    <h1 class="text-2xl font-bold mb-4">Manage Backlinks</h1>

    <!-- Add New Backlink Button -->
    <a href="<?php echo e(route('backlinks.create')); ?>" class="bg-blue-500 text-white px-4 py-2 rounded">Add Backlink</a>

    <!-- Backlink List -->
    <div class="mt-6">
        <table class="w-full border-collapse border border-gray-300">
            <thead>
                <tr class="bg-gray-200">
                    <th class="border px-4 py-2">Title</th>
                 
                    <th class="border px-4 py-2">Domains</th>
                    <th class="border px-4 py-2">Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $backlinks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $backlink): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr class="border">
                    <td class="border px-4 py-2"><?php echo e($backlink->title); ?></td>
                    
                    <td class="border px-4 py-2"><?php echo e($backlink->domains); ?></td>
                    <td class="border px-4 py-2">
                        <a href="<?php echo e(route('backlinks.edit', $backlink->id)); ?>" class="text-yellow-500 mr-2">Edit</a>
                        
                        <!-- Delete Button with Confirmation -->
                        <form action="<?php echo e(route('backlinks.destroy', $backlink->id)); ?>" method="POST" class="inline delete-form">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <button type="button" class="text-red-500 delete-btn" data-id="<?php echo e($backlink->id); ?>">Delete</button>
                        </form>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
</div>

<!-- JavaScript for Delete Confirmation -->
<script>
    document.addEventListener("DOMContentLoaded", function() {
        const deleteButtons = document.querySelectorAll(".delete-btn");

        deleteButtons.forEach(button => {
            button.addEventListener("click", function() {
                let backlinkId = this.dataset.id;
                if (confirm("Are you sure you want to delete this backlink? This action cannot be undone!")) {
                    this.closest("form").submit();
                }
            });
        });
    });
</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/pbnsliderpanel/public_html/resources/views/backlinks/index.blade.php ENDPATH**/ ?>