

<?php $__env->startSection('content'); ?>
<div class="container mx-auto p-6" x-data="{ openMovePopup: false, selectedListItemId: null }">
    <h1 class="text-3xl font-bold text-gray-900 mb-6">Slide Details</h1>

    <!-- Slide Details -->
    <div class="bg-white shadow-lg rounded-lg p-8">
        <div class="mb-6">
            <h2 class="text-xl font-semibold text-gray-800">Group Name:</h2>
            <p class="text-gray-600"><?php echo e($slide->group_name); ?></p>
        </div>

        <div class="mb-6">
            <h2 class="text-xl font-semibold text-gray-800">Heading:</h2>
            <p class="text-gray-600"><?php echo e($slide->heading); ?></p>
        </div>

        <!-- List Items -->
        <div>
            <h2 class="text-xl font-semibold text-gray-800 mb-4">List Items:</h2>
            <?php if($slide->listItems->isEmpty()): ?>
                <p class="text-gray-600">No list items available.</p>
            <?php else: ?>
                <?php $__currentLoopData = $slide->listItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="mb-6 p-4 bg-gray-50 rounded-lg shadow-sm">
                        <h3 class="text-lg font-semibold text-gray-700"><?php echo e($item->list_name); ?></h3>
                        <p class="text-gray-600"><?php echo e($item->domains); ?></p>

                        <!-- Move Button -->
                        <button @click="openMovePopup = true; selectedListItemId = <?php echo e($item->id); ?>" class="bg-purple-600 text-white px-4 py-2 rounded-lg shadow-md hover:bg-purple-700 transition duration-300 mt-4 flex items-center justify-center">
                            <i class="fas fa-arrows-alt mr-2"></i> Move to Another Slide
                        </button>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endif; ?>
        </div>

        <!-- Move to Another Slide Popup -->
        <div x-show="openMovePopup" class="fixed inset-0 flex items-center justify-center z-50 backdrop-blur-sm">
            <div class="bg-white p-6 rounded-lg shadow-lg w-96">
                <h3 class="text-lg font-semibold text-gray-800 mb-4">Move List Item to Another Slide</h3>
                <form method="POST" action="<?php echo e(route('list-items.move')); ?>">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="list_item_id" x-bind:value="selectedListItemId">

                    <div class="mb-6">
                        <label for="slide_id" class="block text-gray-700">Select Slide</label>
                        <select name="slide_id" id="slide_id" class="border border-gray-300 rounded-lg w-full py-2 px-4 focus:outline-none focus:border-purple-500 focus:ring-2 focus:ring-purple-200 transition duration-300">
                            <?php $__currentLoopData = $allSlides; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $otherSlide): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($otherSlide->id); ?>"><?php echo e($otherSlide->group_name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <div class="flex justify-end space-x-4">
                        <button type="button" @click="openMovePopup = false" class="bg-gray-500 text-white py-2 px-4 rounded-lg shadow-md hover:bg-gray-600 transition duration-300">
                            Cancel
                        </button>
                        <button type="submit" class="bg-purple-600 text-white py-2 px-4 rounded-lg shadow-md hover:bg-purple-700 transition duration-300">
                            Move
                        </button>
                    </div>
                </form>
            </div>
        </div>

        <!-- Created By and Modified By -->
        <?php if($currentUserRole == 2): ?>
            <div class="mt-8">
                <h2 class="text-xl font-semibold text-gray-800">Created By:</h2>
                <p class="text-gray-600"><?php echo e($slide->created_by ? $slide->creator->name : 'N/A'); ?></p> 

                <h2 class="text-xl font-semibold text-gray-800 mt-4">Last Modified By:</h2>
                <p class="text-gray-600"><?php echo e($slide->updater ? $slide->updater->name : 'N/A'); ?></p>
            </div>
        <?php endif; ?>
    </div>

    <!-- Back to Index Button -->
    <div class="mt-8 flex justify-between">
        <a href="<?php echo e(route('slides.index')); ?>" class="bg-purple-600 hover:bg-purple-700 text-white py-3 px-6 rounded-lg shadow-md flex items-center justify-center transition duration-300">
            <i class="fas fa-arrow-left mr-2"></i> Back to Slide List
        </a>

        <!-- Edit Button -->
        <a href="<?php echo e(route('slides.edit', $slide)); ?>" class="bg-purple-600 hover:bg-purple-700 text-white py-3 px-6 rounded-lg shadow-md flex items-center justify-center transition duration-300">
            <i class="fas fa-edit mr-2"></i> Edit Slide
        </a>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/pbnsliderpanel/public_html/resources/views/slides/show.blade.php ENDPATH**/ ?>