

<?php $__env->startSection('title', 'Trash'); ?>

<?php $__env->startSection('content'); ?>
<div class="container mx-auto p-6">
    <h1 class="text-3xl font-extrabold text-gray-800 mb-6">Trash</h1>

    <div class="flex space-x-4 mb-6">
        <a href="<?php echo e(route('slides.index')); ?>" class="bg-purple-600 hover:bg-purple-700 text-white px-5 py-2 rounded shadow flex items-center">
            <i class="fas fa-arrow-left mr-2"></i> Back to Slides
        </a>
    </div>

    <?php if(session('success')): ?>
        <div class="bg-green-500 text-white p-3 rounded shadow mb-6 flex items-center">
            <i class="fas fa-check-circle mr-2"></i> <?php echo e(session('success')); ?>

        </div>
    <?php endif; ?>

    <?php if($slides->isEmpty()): ?>
        <div class="bg-yellow-100 text-yellow-800 p-3 rounded shadow mb-6">
            <i class="fas fa-info-circle mr-2"></i> No slides in trash.
        </div>
    <?php else: ?>
        <?php $__currentLoopData = $slides; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $slide): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="bg-white shadow-lg p-6 mb-6 rounded-lg flex justify-between items-center">
                <div>
                    <h2 class="text-2xl font-bold text-purple-700"><?php echo e($slide->group_name); ?></h2>
                    <p class="text-gray-600"><?php echo e($slide->heading); ?></p>
                </div>
                <div class="flex space-x-4">
                    <form action="<?php echo e(route('slides.restore', $slide->id)); ?>" method="POST" x-data="{ open: false }">
                        <?php echo csrf_field(); ?>
                        <button type="button" @click="open = true" class="bg-blue-500 hover:bg-blue-600 text-white px-5 py-2 rounded shadow flex items-center">
                            <i class="fas fa-undo mr-2"></i> Restore
                        </button>
                        <div x-show="open" @click.away="open = false" class="fixed inset-0 flex items-center justify-center z-50">
                            <div class="absolute inset-0 bg-black bg-opacity-60 z-40"></div>
                            <div class="bg-white p-6 rounded-lg shadow-lg relative z-50 max-w-sm w-full">
                                <h3 class="text-lg font-semibold mb-4">Are you sure?</h3>
                                <p class="mb-6">Do you really want to restore this slide?</p>
                                <div class="flex justify-end space-x-4">
                                    <button @click.prevent="open = false" class="bg-gray-500 hover:bg-gray-600 text-white px-4 py-2 rounded">Cancel</button>
                                    <button type="submit" class="bg-blue-500 hover:bg-blue-600 text-white px-4 py-2 rounded">Confirm</button>
                                </div>
                            </div>
                        </div>
                    </form>
                    <form action="<?php echo e(route('slides.forceDelete', $slide->id)); ?>" method="POST" x-data="{ open: false }">
    <?php echo csrf_field(); ?>
    <?php echo method_field('DELETE'); ?>

    <button type="button" @click="open = true" class="bg-red-500 hover:bg-red-600 text-white px-5 py-2 rounded shadow flex items-center">
        <i class="fas fa-trash-alt mr-2"></i> Delete Permanently
    </button>

    <div x-show="open" @click.away="open = false" class="fixed inset-0 flex items-center justify-center z-50">
        <div class="absolute inset-0 bg-black bg-opacity-60 z-40"></div>
        <div class="bg-white p-6 rounded-lg shadow-lg relative z-50 max-w-sm w-full">
            <h3 class="text-lg font-semibold mb-4">Are you sure?</h3>
            <p class="mb-6">Do you really want to delete this slide permanently? This action cannot be undone.</p>
            <div class="flex justify-end space-x-4">
                <button @click.prevent="open = false" class="bg-gray-500 hover:bg-gray-600 text-white px-4 py-2 rounded">Cancel</button>
                <button type="submit" class="bg-red-500 hover:bg-red-600 text-white px-4 py-2 rounded">Confirm</button>
            </div>
        </div>
    </div>
</form>

                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php echo e($slides->links()); ?>

    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\shuvo\Desktop\pbn\pbn_slider\resources\views\slides\trash.blade.php ENDPATH**/ ?>